package jamezo97.clonecraft;

import jamezo97.clonecraft.network.FieldValue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.CCEntityClientPlayerMP;
import net.minecraft.client.entity.CCEntityOtherPlayerMP;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.inventory.CloneCraftGuiInventoryHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.CloneCraftInventoryHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class CloneCraftUtils {

	//Don't include black, nearly impossible to read
	public static char getClosestColourChar(int colour){
		int[] colours = new int[]{0x0000aa, 0x00aa00, 0x00aaaa, 0xaa0000, 0xaa00aa, 0xffaa00, 0x2a2a2a, 0x555555, 0x5555ff, 0x55ff55, 0x55ffff, 0xff5555, 0xff55ff, 0xffff55, 0xffffff};
		char[] colourCodes = "123456789abcdef".toCharArray();
		int r1 = (colour >> 16) & 0xff;
		int g1 = (colour >> 8) & 0xff;
		int b1 = colour & 0xff;

		int closestIndex = -1;
		int diff = -1;
		for(int a = 0; a < colours.length; a++){
			int r2 = (colours[a] >> 16) & 0xff;
			int g2 = (colours[a] >> 8) & 0xff;
			int b2 = colours[a] & 0xff;

			int diffR = r1>r2?r1-r2:r2-r1;
			int diffG = g1>g2?g1-g2:g2-g1;
			int diffB = b1>b2?b1-b2:b2-b1;

			int totalDiff = diffR + diffG + diffB;
			if(closestIndex < 0 || totalDiff < diff){
				diff = totalDiff;
				closestIndex = a;
			}
		}
		if(closestIndex > -1){
			return colourCodes[closestIndex];
		}
		return ' ';
	}

	public static EntityTrackerEntry getTracker(Entity e){
		if(e.worldObj != null && !e.worldObj.isRemote && e.worldObj instanceof WorldServer){
			Set set = Reflect.get(((WorldServer)e.worldObj).getEntityTracker(), Reflect.trackedEntities, Set.class);
			if(set != null){
				Iterator<EntityTrackerEntry> it = set.iterator();
				while(it.hasNext()){
					EntityTrackerEntry entry = it.next();
					if(entry != null && entry.myEntity == e){
						return entry;
					}
				}
			}
		}
		return null;
	}

	public static HashMap loadHashmap(DataInputStream in) throws Exception{
		String s = in.readUTF();
		String s2 = in.readUTF();
		HashMap map = new HashMap();
		return null;
	}

	public static void saveHashMap(Map map, DataOutputStream out) throws Exception{
		out.writeInt(map.size());
		for(Iterator<Entry<?, ?>> it = map.entrySet().iterator(); it.hasNext();){
			Entry<?, ?> entry = it.next();
			Object key = entry.getKey();
			Object value = entry.getValue();
			int keyId = FieldValue.getTypeID(key.getClass());
			int valueId = FieldValue.getTypeID(value.getClass());
			out.write(keyId);
			out.write(valueId);
		}
	}
	
	@SideOnly(value = Side.CLIENT)
	public static void renderSlotResourceOverlays(GuiContainer gui){
		Container container = gui.inventorySlots;
		GL11.glPushMatrix();
		GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
		GL11.glTranslatef(CloneCraftGuiInventoryHelper.getGuiLeft(gui), CloneCraftGuiInventoryHelper.getGuiTop(gui), 0.0f);
		GL11.glScalef(0.0625f, 0.0625f, 0.0f);
		ResourceLocation resource;
		for(int a = 0; a < container.inventorySlots.size(); a++){
			Slot slot = (Slot)container.inventorySlots.get(a);
			if(!slot.getHasStack() && (resource = CloneCraftInventoryHelper.getSlotResource(slot)) != null){
				Minecraft.getMinecraft().getTextureManager().bindTexture(resource);
				gui.drawTexturedModalRect(slot.xDisplayPosition*16, slot.yDisplayPosition*16, 0, 0, 256, 256);
			}

		}
		GL11.glPopMatrix();
	}

	@SideOnly(value = Side.CLIENT)
	public static EntityPlayer convertPlayerToCustomized(EntityPlayer e) {
		Minecraft mc = Minecraft.getMinecraft();
		EntityPlayer newPlayerEntity = null;
		if(e instanceof EntityClientPlayerMP){
			EntityClientPlayerMP oldPlayer = (EntityClientPlayerMP)e;
			CCEntityClientPlayerMP newPlayer = new CCEntityClientPlayerMP(oldPlayer);
			if(mc.thePlayer == oldPlayer){
				mc.thePlayer = newPlayer;
			}
			if(oldPlayer == mc.renderViewEntity){
				mc.renderViewEntity = newPlayer;
			}
			newPlayerEntity = newPlayer;
		}else if(e instanceof EntityOtherPlayerMP){
			EntityOtherPlayerMP oldPlayer = (EntityOtherPlayerMP)e;
			newPlayerEntity = new CCEntityOtherPlayerMP(oldPlayer);
		}else{
			return e;
		}
		newPlayerEntity.entityId = e.entityId;
		
		mc.theWorld.removePlayerEntityDangerously(e);
		mc.theWorld.spawnEntityInWorld(newPlayerEntity);

		return newPlayerEntity;
	}

}
